package systems.dennis.shared.validation;

import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.service.AbstractService;

public class FieldIsUniqueValidator implements ValueValidator<Object, Object> {
    @Override
    public ValidationResult validate(Object element, Object value, ValidationContent content) {
        boolean isValueEmpty = value == null || value.toString().isEmpty();

        if (isValueEmpty) {
            return ValidationResult.PASSED;
        }

        var provider = content.getContext().getDataFilterProvider().eq(content.getField(), value);

        if (content.isEdit()) {
            provider.and(content.getContext().getDataFilterProvider().idNot(((AbstractForm) element).getId()));
        }

        AbstractService service = (AbstractService<?, ?>) content.getContext().getBean(content.getServiceClass());
        if (service.count( provider) > 0) {
            return ValidationResult.fail("field." + content.getField() + ".not.unique");
        }


        return ValidationResult.PASSED;
    }
}
