package systems.dennis.shared.controller.items;


import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * List  object interface. Implementing this interface, will automatically create ../list/
 *
 * @param <DB_TYPE>       Entity which is managed by this interface and Service
 */
@Secured
public interface AbstractSelfItemsListController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>

        extends Serviceable<DB_TYPE, ID_TYPE>, MagicList<DB_TYPE, ID_TYPE>, Transformable< DB_TYPE, FORM> {

    @GetMapping("/list")
    @ResponseBody
    @WithRole
    default ResponseEntity<Page<FORM>> getData(@RequestParam (value = "limit", required = false) Integer limit,
                                               @RequestParam(value = "page", required = false) Integer page) {

       var specification =modifySearchSpecification(getContext().getDataFilterProvider().ofUser(getModel(), getContext().getCurrentUser()));
        var data = getService().find(specification, limit, page);
        List<FORM> result= new ArrayList<>();


        if (data.isEmpty()){

            result = (List<FORM>) onEmpty().doOnEmptyResults();
        }else {
            for (var item : data) {
                result.add(toForm(item));
            }
        }

        Page<FORM> request = new PageImpl<>(result, PageRequest.of(page, limit), result.size());
        return ResponseEntity.ok(request);
    }

    default OnEmptyResult onEmpty(){
        return OnEmptyResult.INSTANCE;
    }

    default AbstractDataFilter<DB_TYPE> modifySearchSpecification(AbstractDataFilter specification){
        return specification;
    }


}
