package systems.dennis.shared.controller.items;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.form.CountResponse;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.service.AbstractParentalService;

import java.io.Serializable;
import java.util.Map;

@Secured
public interface AbstractParentalController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable> extends Transformable<DB_TYPE, FORM>, Serviceable<DB_TYPE, ID_TYPE>, MagicList<DB_TYPE, ID_TYPE> {

    @GetMapping("/tree/count/parent/{id}")
    @ResponseBody
    @WithRole
    default ResponseEntity<CountResponse> countByParent(@PathVariable("id") ID_TYPE id) {
        AbstractParentalService<DB_TYPE, ID_TYPE> bean = getService();
        long count = bean.countByParent(id);

        CountResponse response = new CountResponse();
        response.setCount(count);
        return ResponseEntity.ok(response);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    @WithRole
    default ResponseEntity<Page<Map<String, Object>>> findRootElements(@RequestParam(value = "limit", required = false) Integer limit,
                                                                    @RequestParam(value = "page", required = false) Integer page) {
        AbstractParentalService<DB_TYPE, ID_TYPE> bean = getService();
        Page<DB_TYPE> elements = bean.findRootElements(page, limit);

        return ResponseEntity.ok(toFormPage(elements));
    }

    @GetMapping("/tree/parent/{id}")
    @ResponseBody
    @WithRole
    default ResponseEntity<Page<Map<String, Object>>> findByParent(@PathVariable ("id") ID_TYPE id,
                                                                   @RequestParam(value = "limit", required = false) Integer limit,
                                                                   @RequestParam(value = "page", required = false) Integer page) {
        AbstractParentalService<DB_TYPE, ID_TYPE> bean = getService();
        Page<DB_TYPE> elements = bean.findByParent(id, limit, page);

        return ResponseEntity.ok(toFormPage(elements));
    }
}
