package systems.dennis.shared.controller.items;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;

@Secured
public interface AbstractGetOrCreateByIdController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable> extends Serviceable<DB_TYPE, ID_TYPE>, Transformable<DB_TYPE, FORM> {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable("id") ID_TYPE id, @RequestParam(required = false) String param) {

        DB_TYPE type = getService().findById(id).orElse(null);
        if (type == null) {
            var res = getService().save(fromForm(createNew(param)));
            return ResponseEntity.ok(toForm(res));
        }
        return ResponseEntity.ok(toForm(type));
    }

    FORM createNew(String ownerId);


}
