package systems.dennis.shared.annotations.security;

import org.springframework.stereotype.Service;
import systems.dennis.shared.beans.IdToAuthorizationIdBean;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.importer.Authorization;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;

public interface ISecurityUtils<T extends Serializable> {
    T getUserDataId();


    default void isMy(Object o){ };

    TokenData getToken();

    boolean isAdmin();

    boolean hasRole(String role);

    String getUserLanguage();

     static AbstractDataFilter belongsToMeQuery(Class cl, Serializable userId, WebContext.LocalWebContext context){
        return context.getDataFilterProvider().ofUser(cl, userId);
    }

    default AbstractDataFilter belongsToMeQuery( Class cl, WebContext.LocalWebContext context){
        return  belongsToMeQuery(cl, getUserDataId(), context);
    }
    default  AbstractDataFilter belongsToMeSpecification(Class cl, WebContext.LocalWebContext context){
        return  belongsToMeQuery(cl, getUserDataId(), context);
    }

    default String getScope(){
         try {
             return getToken().getScope();
         } catch (Exception e){
             return "Default";
         }
    }
}
