package systems.dennis.shared.annotations;

import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.service.AbstractService;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface WebFormsSupport {
    public static final String DEFAULT_NAME = "default";
    Class<? extends AbstractService> value() ;
    String searchName() default DEFAULT_NAME;
    String fieldName() default DEFAULT_NAME;

    boolean allowEntitySearch() default true;

    /**
     * Overrides Service parameter model, when it's required
     * @return model
     */
    Class<? extends AbstractForm> form() default AbstractForm.class;



}
