package systems.dennis.shared.controller.items.magic;

import lombok.Data;
import lombok.SneakyThrows;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.entity.IDHolder;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.OperationNotAllowedException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.*;

@Data
public class MagicQuery {

    public static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private String field;
    private String type;
    private Object value;

    private String searchName;

    private String dataType;

    @SneakyThrows
    public AbstractDataFilter toQuery(WebContext.LocalWebContext context) {

        AbstractDataFilter provider = null;
        if (dataType.equals("checkbox")) {
            if (value.equals("null")) {
                return context.getDataFilterProvider().isNull(field);
            }
            value = Boolean.valueOf(value.toString());

        }

        if (dataType.startsWith("date")) {

            if (value instanceof Date) {
                this.value = trim((Date) value);
            } else {
                this.value = trim(format.parse(((String) value).replaceAll("/", "."), new ParsePosition(0)));
            }

        }

        if (dataType.equals("object_chooser")) {


            if (value != null && !value.toString().trim().equals("")) {
                if (!IDHolder.class.isAssignableFrom(value.getClass())) {
                    try {
                        value = context.getBean(SearchEntityApi.findServiceByType(searchName)).findById((Serializable) value).orElseThrow(() -> ItemNotFoundException.fromId(String.valueOf(value)));
                    } catch (Exception e) {
                        System.out.println(value);
                    }
                }
            }
        }

        if (Objects.equals(this.type, "=")) {
            if (value == null || value.toString().isBlank()) {
                //todo ?? why?
                return context.getDataFilterProvider().isNull(field);
            }
            return context.getDataFilterProvider().eq(field, value);
        }

        if (Objects.equals(this.type, "!=")) {
            if (value == null || value.toString().isBlank()) {
                return context.getDataFilterProvider().notNull(field);
            }
            return context.getDataFilterProvider().notEq(field, value);
        }

        if (Objects.equals(this.type, ">=")) {
            return context.getDataFilterProvider().greatEQ(field, value);
        }

        if (Objects.equals(this.type, ">")) {
            return context.getDataFilterProvider().greater(field, value);
        }

        if (Objects.equals(this.type, "<=")) {
            return context.getDataFilterProvider().lessEQ(field, value);
        }

        if (Objects.equals(this.type, "<")) {
            return context.getDataFilterProvider().less(field, value);
        }

        if (Objects.equals(this.type, "%...%")) {
            return context.getDataFilterProvider().setInsensitive(true).contains(field, String.valueOf(value));
        }
        if (Objects.equals(this.type, "!%...%")) {
            return context.getDataFilterProvider().setInsensitive(true).notContains(field, String.valueOf(value));
        }

        if (Objects.equals(this.type, "%...")) {
            return context.getDataFilterProvider().setInsensitive(true).startsWith(field, String.valueOf(value));
        }
        if (Objects.equals(this.type, "!%...")) {
            return context.getDataFilterProvider().setInsensitive(true).notEndsWith(field, String.valueOf(value));
        }

        if (Objects.equals(this.type, "...%")) {
            return context.getDataFilterProvider().setInsensitive(true).endsWith(field, String.valueOf(value));
        }
        if (Objects.equals(this.type, "!...%")) {
            return context.getDataFilterProvider().setInsensitive(true).notEndsWith(field, String.valueOf(value));
        }

        if (Objects.equals(this.type, "is_null")) {
            return context.getDataFilterProvider().isNull(field);
        }

        if (Objects.equals(this.type, "not_null")) {
            return context.getDataFilterProvider().notNull(field);
        }

        if (Objects.equals(this.type, "in")) {
            List<IDPresenter<?>> sourceList = new ArrayList<>();
            if (value != null) {
                IDPresenter<?> model;
                var service = context.getBean(SearchEntityApi.findServiceByType(searchName));

                for (Serializable integer : (List<Serializable>) value) {
                    try {
                        Serializable id = integer;
                        model = (IDPresenter<?>) service.findById(context.getDataFilterProvider().getIdValue(id)).orElseThrow(() -> ItemNotFoundException.fromId(id));
                        sourceList.add(model);
                    } catch (Exception e) {
                        System.out.println(value);
                    }
                }
            }
            return context.getDataFilterProvider().iN(field, sourceList);
        }
        if (Objects.equals(this.type, "not_in")) {
            List<IDPresenter<?>> sourceList = new ArrayList<>();
            if (value != null) {
                IDPresenter<?> model;
                var service = context.getBean(SearchEntityApi.findServiceByType(searchName));

                for (Serializable idValue : (List<Serializable>) value) {
                    try {

                        model = (IDPresenter<?>) service.findById(context.getDataFilterProvider().getIdValue(idValue)).orElseThrow(() -> ItemNotFoundException.fromId(idValue));
                        sourceList.add(model);
                    } catch (Exception e) {
                        System.out.println(value);
                    }
                }
            }
            return context.getDataFilterProvider().notIN(field, sourceList);
        }

        throw new OperationNotAllowedException("Do not know operator send to query");
    }

    public static Date trim(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.HOUR_OF_DAY, 0);

        return calendar.getTime();
    }
}
