package systems.dennis.shared.utils.bean_copier;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.utils.TSDate;

import java.io.Serializable;
import java.util.Date;

public class DateToUTCConverter  implements AbstractTransformer<Serializable> {
    @Override
    public <DB_TYPE extends IDPresenter<Serializable>> Object transform(Object object, DataTransformer transformerDescription, Class<?> toType, WebContext.LocalWebContext context) {
        if (object == null){
            return  null;
        }

        Object result;

        if (object.getClass() == TSDate.class){
            result = ((TSDate)object).UTC().getDate();
            //transform to date from TSDATE
        } else {
            result = TSDate.of((Date) object).UTC();
            //transform to TS date from Date
        }

        return result;
    }
}
