package systems.dennis.shared.controller.items.magic;

import jakarta.servlet.http.HttpServletRequest;
import lombok.SneakyThrows;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.AbstractFormModifier;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.forms.ValidateForm;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.ExtendedForm;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.PojoForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.utils.GeneratedPojoForm;
import systems.dennis.shared.utils.PojoFormField;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

import java.lang.reflect.Field;
import java.util.*;


public interface MagicForm<FORM extends AbstractForm> extends ValidateForm<FORM> {

    Map<String, GeneratedPojoForm> pojoFormCache = new HashMap<>();

    @GetMapping(value = "/root/fetch/form", produces = "application/json")
    @ResponseBody
    @WithRole
    default GeneratedPojoForm fetchForm(HttpServletRequest request, @RequestParam(required = false) Long id) {

        DataRetrieverDescription descriptor = getClass().getAnnotation(WebFormsSupport.class).value()
                .getAnnotation(DataRetrieverDescription.class);

        Class<? extends AbstractForm> formClass = descriptor.form();

        var receivedForm = getPojoForm(formClass, id);
        GeneratedPojoForm changedForm = null;
        receivedForm.setAction(getClass().getAnnotation(RequestMapping.class).value()[0] + (id == null ? "/add" : "/edit"));
        receivedForm.setMethod(id == null ? HttpMethod.POST.name() : HttpMethod.PUT.name());

        if (getContext().getEnv("app.global.allow_form_change", true)) {
            var bean = getContext().getBean(UserSettingsFormInterface.class);
            bean.configForm(getContext(), receivedForm, formClass);
        }

        if (id != null) {
            setPojoFormValue(id, changedForm == null ?  receivedForm : changedForm, getContext());
        }
        var res =  changedForm == null ? receivedForm : changedForm ;

        if (descriptor.formModifier() != AbstractFormModifier.class) {
            AbstractFormModifier modifier = null;
            try {
                modifier = descriptor.formModifier().newInstance();
                modifier.modify(getContext(),request, res);
            } catch (Exception e) {
                //ignored
            }
        }

        return  res;
    }



    default GeneratedPojoForm getPojoForm(Class<? extends AbstractForm> formClass, Long id) {

        if (pojoFormCache.containsKey(formClass.getName())) {
            var res = pojoFormCache.get(formClass.getName());
            res = getContext().getBean(BeanCopier.class).clone(res);
            res.setFieldList(new ArrayList<>(res.getFieldList()));
            return  res;
        } else {
            GeneratedPojoForm generatedPojoForm = new GeneratedPojoForm();

            PojoListView ann = formClass.getAnnotation(PojoListView.class);
            if (Objects.equals(ann.favoriteType(), "")) {
                generatedPojoForm.setObjectType(formClass.getSimpleName());
            } else {
                generatedPojoForm.setObjectType(ann.favoriteType());
            }

            if (formClass.getAnnotation(PojoForm.class) != null) {
                copyTo(formClass.getAnnotation(PojoForm.class), generatedPojoForm);
            } else {
                generatedPojoForm.setTitle(getContext().getScoped(getClass().getSimpleName()).toLowerCase());
                generatedPojoForm.setCommitText("global.submit");
                generatedPojoForm.setShowTitle(true);
            }


            BeanCopier.withEach(formClass, field -> getDescription(field, generatedPojoForm));

            pojoFormCache.put(formClass.getName(), generatedPojoForm);

            generatedPojoForm.getFieldList().sort(Comparator.comparing(PojoFormField::getOrder));

            return getContext().getBean(BeanCopier.class).clone(generatedPojoForm);
        }
    }

    @SneakyThrows
    default void setPojoFormValue(Long id, GeneratedPojoForm pojoForm, WebContext.LocalWebContext context) {
        var service = ((Serviceable) this).getService();
        DataRetrieverDescription descriptor = getClass().getAnnotation(WebFormsSupport.class).value()
                .getAnnotation(DataRetrieverDescription.class);
        var model = service.findByIdOrThrow(id);
        var form = ((Transformable) this).toForm(model);
        pojoForm.setValue(BeanCopier.values(form, model, context));

        if (form instanceof ExtendedForm){
            if (descriptor.formModifier() != AbstractFormModifier.class) {
                var valueFetcherClass = descriptor.formModifier().newInstance();
                pojoForm.getFieldList().forEach(x -> {
                    if (x.getCustomized() != null && x.getCustomized()) {
                        pojoForm.getValue().put(x.getField(),valueFetcherClass.getValue(pojoForm, x.getField(), model)  );
                    }
                });
            }
        }

    }

    default void copyTo(PojoForm annotation, GeneratedPojoForm generatedPojoForm) {
        generatedPojoForm.setTitle(annotation.title().title());
        generatedPojoForm.setShowTitle(annotation.title().show());
        generatedPojoForm.setCommitText(annotation.commitButtonText());
    }

    @SneakyThrows
    default void getDescription(Field x, GeneratedPojoForm generatedForm) {

        if (x.getAnnotation(FormTransient.class) == null) {
            if (x.getAnnotation(PojoFormElement.class) != null && x.getAnnotation(PojoFormElement.class).available()) {
                generatedForm.getFieldList().add(PojoFormField.from(x, getContext()));
            }
        }
    }
}