package systems.dennis.shared.utils;

import org.springframework.stereotype.Component;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.exceptions.TransformException;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.utils.bean_copier.DateTimeAndStringConverter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;

@Component
public class DataTypeConverter extends ApplicationContext {

    public DataTypeConverter(WebContext context) {
        super(context);
    }

    public Object convert(String type, Object value, String searchName) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (type.equals(DEFAULT_TYPES.OBJECT_SEARCH)) {
            return convertToObjectSearch(value, searchName);
        }
        if (type.equals(DEFAULT_TYPES.CHECKBOX)) {
            return convertToCheckbox(value);
        }
        if (type.equals(DEFAULT_TYPES.DATE)) {
            return convertToDate(value);
        }
        if (type.equals(DEFAULT_TYPES.INTEGER)) {
            return convertToInteger(value);
        }
        return value;
    }

    private Object convertToObjectSearch(Object value, String searchName) {
        Long id = Long.valueOf(value.toString());
        return getBean(SearchEntityApi.findServiceByType(searchName)).findByIdOrThrow(id);
    }

    private Object convertToCheckbox(Object value) {
        return Boolean.valueOf(value.toString());
    }

    private Object convertToDate(Object value) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateTimeAndStringConverter.DEFAULT_DATE_TEMPLATE);
            return dateFormat.parse(value.toString());
        } catch (ParseException e) {
            throw new TransformException("failed_to_convert_date");
        }
    }

    private Object convertToInteger(Object value) {
        return Integer.valueOf(value.toString());
    }
}
