package systems.dennis.shared.controller.items;

import lombok.SneakyThrows;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.IDHolder;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.utils.bean_copier.DataTransformer;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface Transformable<DB_TYPE extends AbstractEntity, FORM extends AbstractForm> {

    @SneakyThrows
    default DB_TYPE fromForm(FORM form) {
        var cl = Serviceable.findDeclaredClass(getClass(), getClass().getAnnotation(DataRetrieverDescription.class)).model();

        return afterTransformToDBType((DB_TYPE) getContext().getBean(BeanCopier.class).copy(form, cl), form);

    }

    @SneakyThrows
    default FORM toForm(DB_TYPE model) {
        var cl = Serviceable.findDeclaredClass(getClass(), getClass().getAnnotation(DataRetrieverDescription.class)).form();
        var res = getContext().getBean(BeanCopier.class).copy(model, cl);

        return afterTransformToForm((FORM) res, model);
    }

    @SneakyThrows
    default KeyValue transformValueToTargetType(KeyValue keyValue, Class<?> targetClass,
                                                Class<? extends AbstractForm> sourceClass) {

        Field editField = BeanCopier.findField(keyValue.getKey(), sourceClass);
        DataTransformer transformer = editField.getAnnotation(DataTransformer.class);

        Object transformableValue = keyValue.getValue();

        if (transformer != null) {
            var converter = transformer.transFormWith().newInstance();
            if (IDHolder.class.isAssignableFrom( transformableValue.getClass())) {
                transformableValue = converter.transform(transformableValue, transformer, ((IDHolder) transformableValue).getId().getClass(), getContext());
            } else {
                transformableValue = converter.transform(transformableValue, transformer, targetClass, getContext());
            }
        }

        return new KeyValue(keyValue.getKey(), transformableValue);
    }

    @SneakyThrows
    default KeyValue transformValueToModelType(KeyValue keyValue) {
        var description = getClassDescription();
        var targetClass = description.model();
        var sourceClass = description.form();

        return transformValueToTargetType(keyValue, targetClass, sourceClass);
    }

    @SneakyThrows
    default KeyValue transformValueToFormType(KeyValue keyValue) {
        var description = getClassDescription();
        var targetClass = description.form();
        var sourceClass = description.model();
//todo check what is here and why it was wrong!
        return transformValueToTargetType(keyValue, sourceClass, targetClass);
    }

    default DataRetrieverDescription getClassDescription() {
        return getClass()
                .getAnnotation(WebFormsSupport.class).value()
                .getAnnotation(DataRetrieverDescription.class);
    }

    default FORM afterTransformToForm(FORM ob, DB_TYPE origin) {
        return ob;
    }

    default DB_TYPE afterTransformToDBType(DB_TYPE ob, FORM form) {
        return ob;
    }

    default Page<Map<String, Object>> toFormPage(Page<DB_TYPE> page) {
        BeanCopier beanCopier = getContext().getBean(BeanCopier.class);
        var cl = Serviceable.findDeclaredClass(getClass(), getClass().getAnnotation(DataRetrieverDescription.class)).form();

        List<Map<String, Object>> data = new ArrayList<>();
        for (int i = 0; i < page.getContent().size(); i++) {
            AbstractEntity model = page.getContent().get(i);
            var form = beanCopier.copy(model, cl);
            data.add(BeanCopier.values(form, model, getContext()));
        }
        return new PageImpl<>(data, page.getPageable(), page.getTotalElements());
    }

    WebContext.LocalWebContext getContext();
}
