package systems.dennis.shared.controller.items;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;

@Secured
public interface AbstractGetByIdController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable> extends Serviceable<DB_TYPE, ID_TYPE>, Transformable<DB_TYPE, FORM> {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable ("id") ID_TYPE id) {
        DB_TYPE type = (DB_TYPE) getService().findById(id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        if (type == null){
            throw ItemNotFoundException.fromId(id);
        }
        return ResponseEntity.ok(toForm(type));
    }


}
