package systems.dennis.shared.validation;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.service.AbstractService;

public class FieldIsUniqueValidator implements ValueValidator<Object, Object> {
    @Override
    public ValidationResult validate(Class serviceClass, Object element, String field, Object value, boolean edit, WebContext.LocalWebContext context) {
        boolean isValueEmpty = value == null || value.toString().isEmpty();

        if (isValueEmpty) {
            return ValidationResult.PASSED;
        }

        var provider = context.getDataFilterProvider().eq(field, value);

        if (edit) {
            provider.and(context.getDataFilterProvider().idNot(((AbstractForm) element).getId()));
        }

        AbstractService service = (AbstractService<?, ?>) context.getBean(serviceClass);
        if (service.count( provider) > 0) {
            return ValidationResult.fail("field." + field + ".not.unique");
        }


        return ValidationResult.PASSED;
    }
}
