package systems.dennis.shared.utils.bean_copier;

import lombok.SneakyThrows;
import org.apache.logging.log4j.util.Strings;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.TransformException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.service.AbstractService;

import java.io.Serializable;

/**
 * Objects in the system for today can contain of String or Longs (more or less this is default behaviour)
 * In feature by request this can be transformed to the service implemented in each individual case separately
 * @param <ID_TYPE> - a type of ID of the object
 */
public class IdToObjectTransformer<ID_TYPE extends Serializable> implements AbstractTransformer<ID_TYPE> {

    @SneakyThrows
    @Override
    public <DB_TYPE extends IDPresenter<ID_TYPE>> Object transform(Object object, DataTransformer transformerDescription, Class<?> toType, WebContext.LocalWebContext context) {
        if (object == null) {
            return null;
        }

        if (object instanceof Long && object.equals(0L)) {
            return null;
        }

        if (object.getClass() == String.class && Strings.isBlank((String) object)){
            return null;
        }

        if (isFormObjectTOId(toType)){
            return ((AbstractEntity<?>) object).getId();
        }
        //so get Object By id
        return  ((AbstractService<DB_TYPE , ID_TYPE>) context.getBean(transformerDescription.additionalClass()))
                .findById((ID_TYPE) object)
                .orElseThrow(()-> new TransformException(String.valueOf(object)));
    }

    public boolean isFormObjectTOId(Class<?> toType) {
        return toType == Long.class || toType == String.class;
    }
}
