package systems.dennis.shared.utils.bean_copier;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;

public class BeanCopierTransformer<ID_TYPE extends Serializable> implements AbstractTransformer<ID_TYPE> {

    @Override
    public <DB_TYPE extends IDPresenter<ID_TYPE>> Object transform(Object object, DataTransformer transformerDescription, Class<?> toType, WebContext.LocalWebContext context) {
        if (context == null){
            return null;
        }
        return context.getBean(BeanCopier.class).copy(object, toType);
    }
}
