package systems.dennis.shared.utils.bean_copier;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.AbstractTransformerException;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;

public interface AbstractTransformer<ID_TYPE extends Serializable> {

    default boolean returnSameIfTypesAreEqual(Object from, Class<?> toType) {
        if (toType == null) {
            throw new AbstractTransformerException(getClass().getSimpleName());
        }
        return from == null || toType.isAssignableFrom(from.getClass());
    }

    <DB_TYPE extends IDPresenter< ID_TYPE>> Object transform(Object object, DataTransformer transformerDescription, Class<?> toType, WebContext.LocalWebContext context);
}
