package systems.dennis.shared.service;

import org.springframework.data.domain.Page;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.utils.ApplicationContext;

import java.io.Serializable;

public abstract class ParentalService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> extends ApplicationContext implements AbstractService<DB_TYPE, ID_TYPE> {

    public String getParentField() {
        return "parent";
    }

    public ParentalService(WebContext holder) {
        super(holder);
    }

    public long countByParent(ID_TYPE id) {

        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().id(id);
        return count(specification.and(getAdditionalSpecification()));
    }

    public long countByRoot(DB_TYPE x) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), x);
        return count(specification.and(getAdditionalSpecification()));
    }


    public Page<DB_TYPE> findRootElements(int page, int limit) {
        AbstractDataFilter<DB_TYPE>  specification = getFilterImpl().notNull(getParentField());
        return find(specification.and(getAdditionalSpecification()),  limit, page);
    }

    public Page<DB_TYPE> findByParent(Long parentId, int limit, int page) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), parentId);
        return find(specification.and(getAdditionalSpecification()),  limit, page);
    }
}
