package systems.dennis.shared.repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.stereotype.Repository;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;
import java.util.Optional;

@NoRepositoryBean @Repository
public interface AbstractFilterRepo<ENTITY extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> {

    Optional<ENTITY> filteredOne(AbstractDataFilter<?> one);

    Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first);

    Page<ENTITY> filteredData(AbstractDataFilter<?> specification);


    Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable);


    long filteredCount(AbstractDataFilter<?> filter);
}
