package systems.dennis.shared.repository;

import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import systems.dennis.shared.model.AbstractUserAssignableElement;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;
import java.util.List;

public interface AbstractDataFilter<T extends IDPresenter<?>> {

    String EQUALS_OPERATOR = "equals";
    String STARTS_WITH_OPERATOR = "startsWith";
    String NOT_STARTS_WITH_OPERATOR = "notStartsWith";
    String ENDS_WITH_OPERATOR = "endsWith";
    String NOT_ENDS_WITH_OPERATOR = "notEndsWith";
    String MORE_THEN = "gt";
    String LESS_THEN = "lt";
    String LESS_EQUALS = "le";
    String MORE_EQUALS = "ge";
    String CONTAINS_OPERATOR = "contains";
    String IN = "in";
    String NOT_IN = "not_in";
    String NOT_CONTAINS_OPERATOR = "_nc_";
    String NOT_EMPTY = "_ne_";
    String EMPTY = "_em_";
    String NOT_EQUALS_OPERATOR = "notEquals";
    String NULL_OPERATOR = "null";
    String NOT_NULL_OPERATOR = "notNull";

    <E extends  AbstractDataFilter<T>>E operator(String field, Object value, String type);

    <E extends  AbstractDataFilter<?>>E and(E filter);

    <E extends  AbstractDataFilter<?>>E or(E filter);

    default <E extends  AbstractDataFilter<T>>E  eq(String field, Object value){
        return (E) operator(field, value, EQUALS_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  id( Object value){
        return (E) operator(IDPresenter.ID_FIELD, value, EQUALS_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  idNot( Object value){
        return (E) operator(IDPresenter.ID_FIELD, value, NOT_EQUALS_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  ofUser( Serializable user){
        return (E) operator(AbstractUserAssignableElement.USER_DATA_ID, user, EQUALS_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  notEq(String field, Object value){
        return (E) operator(field, value, NOT_EQUALS_OPERATOR);
    }
    default <E extends  AbstractDataFilter<T>>E  notIN(String field, List<?> value){
        return (E) operator(field, value, NOT_IN);
    }
    default  <E extends  AbstractDataFilter<T>>E  iN(String field, List<?> value){
        return (E) operator(field, value, IN);
    }

    default <E extends  AbstractDataFilter<T>>E  contains(String field, String value){
        return (E) operator(field, value, CONTAINS_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  notContains(String field, String value){
        return (E) operator(field, value, NOT_CONTAINS_OPERATOR);
    }
    default <E extends  AbstractDataFilter<T>>E  greater(String field, Object value){
        return (E) operator(field, value, MORE_THEN);
    }

    default <E extends  AbstractDataFilter<T>>E  greatEQ(String field, Object value){
        return (E) operator(field, value, MORE_EQUALS);
    }

    default <E extends  AbstractDataFilter<T>>E  lessEQ(String field, Object value){
        return (E) operator(field, value, LESS_EQUALS);
    }
    default <E extends  AbstractDataFilter<T>>E  less(String field, Object value){
        return (E) operator(field, value, LESS_THEN);
    }

    default <E extends  AbstractDataFilter<T>>E  startsWith(String field, String value){
        return (E) operator(field, value, STARTS_WITH_OPERATOR);
    }

    default <E extends  AbstractDataFilter<T>>E  notStartsWith(String field, String value){
        return (E) operator(field, value, NOT_STARTS_WITH_OPERATOR);
    }
    default <E extends  AbstractDataFilter<T>>E  endsWith(String field, String value){
        return (E) operator(field, value, ENDS_WITH_OPERATOR);
    }
    default <E extends  AbstractDataFilter<T>>E  empty(String field){
        return (E) operator(field, null, EMPTY);
    }
    default <E extends  AbstractDataFilter<T>>E  notEmpty(String field){
        return (E) operator(field, null, NOT_EMPTY);
    }
    default <E extends  AbstractDataFilter<T>>E  isNull(String field){
        return (E) operator(field, null, NULL_OPERATOR);
    }
    default <E extends  AbstractDataFilter<T>>E  notNull(String field){
        return (E) operator(field, null, NOT_NULL_OPERATOR);
    }
     default <E extends  AbstractDataFilter<T>>E notEndsWith(String field, String value){
        return (E) operator(field, value, NOT_ENDS_WITH_OPERATOR);
    }
      <E extends  AbstractDataFilter<T>>E comparasionType(Class<?> type);

    boolean isClosed();

    /**
     * When used, next query changes should replace this result
     * @return query
     */
    default    <E extends  AbstractDataFilter<T>>E  empty(){
        return (E) operator(null, null, null);
    }

    AbstractDataFilter<T> setInsensitive(boolean insensitive);
    AbstractDataFilter<T> setComplex(boolean complex);
    AbstractDataFilter<T> setJoinOn(String on);

    Serializable getIdValue(Object id);
    
    boolean isEmpty();


    String getOperator();

    Object getValue();

    Class<?> getFieldClass();

    boolean isComplex();

    String getField();

    String getOn();

    <T>T getQueryRoot();
}
