package systems.dennis.shared.beans;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

import java.io.Serializable;

/**
 * When item is deleted or edited this bean is called to save delete history
 * Annotation @Primary is required on the implementation
 * <b>This is a default nothing happening implementation! </b>
 * @param <T> Object type extended normally from {@link systems.dennis.shared.entity.AbstractEntity}
 * @param <ID_TYPE> ID type of String/Long or any other
 */
@Service
@Scope("singleton")
public class AbstractEditDeleteHistoryBean<T, ID_TYPE extends Serializable> extends ApplicationContext {

    private Boolean enabled;

    public AbstractEditDeleteHistoryBean(WebContext context) {
        super(context);
    }

    public void edit(T from, T to){

    }
    public void delete(ID_TYPE id, T from){

    }

    public void throwIfDeleted(ID_TYPE id, Class object){

    }


    public boolean isEnabled(){
        if (enabled != null){
            return  enabled;
        }
        return this.enabled = getContext().getEnv("global.save.versions", false);

    }
}
