package systems.dennis.shared.annotations.security;

import org.springframework.stereotype.Service;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;

@Service
public interface ISecurityUtils<T extends Serializable> {
    String USER_ID_FIELD = "userDataId";
    T getUserDataId();

    void assignUser(AbstractEntity<T> pojo);

    void assignUser(AbstractEntity<T> form, AbstractEntity<T> pojoOriginal);

    default void isMy(Object o){ };

    TokenData getToken();

    boolean isAdmin();

    boolean hasRole(String role);

    String getUserLanguage();

     static AbstractDataFilter belongsToMeQuery(Serializable userId, WebContext.LocalWebContext context){
        return context.getDataFilterProvider().ofUser(userId);
    }

    default AbstractDataFilter belongsToMeQuery( WebContext.LocalWebContext context){
        return  belongsToMeQuery(getUserDataId(), context);
    }
    default  AbstractDataFilter belongsToMeSpecification(WebContext.LocalWebContext context){
        return  belongsToMeQuery(getUserDataId(), context);
    }
}
