package systems.dennis.shared.annotations;

import jakarta.servlet.http.HttpServletRequest;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;

import systems.dennis.shared.utils.GeneratedPojoForm;
import systems.dennis.shared.utils.GeneratedPojoList;

import java.io.Serializable;
import java.util.Map;

public interface AbstractFormModifier <ID_TYPE> {
    void modify(WebContext.LocalWebContext context, HttpServletRequest request, GeneratedPojoForm form);

    <T>Object getValue( GeneratedPojoForm form, String field, T object );

    <T extends Serializable>Object getValue(String key, AbstractEntity<T> model);


    void modify(WebContext.LocalWebContext context, GeneratedPojoList res, HttpServletRequest request);
    boolean hasCustomValues(Object model);

    void appendToValues(Map<String, Object> values, Object model);
}
