package systems.dennis.shared.utils.bean_copier;

import lombok.SneakyThrows;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.TransformException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.service.AbstractService;

import java.io.Serializable;

public abstract class IdToObjectTransformer<ID_TYPE extends Serializable> implements AbstractTransformer<ID_TYPE> {
    @SneakyThrows
    @Override
    public <DB_TYPE extends IDPresenter<ID_TYPE>> Object transform(Object object, DataTransformer transformerDescription, Class<?> toType, WebContext.LocalWebContext context) {
        if (object == null) {
            return null;
        }

        if (object instanceof Long && object.equals(0L)) {
            return null;
        }

        if (isFormObjectTOId()){
            return ((AbstractEntity<?>) object).getId();
        }
        //so get Object By id
        return  ((AbstractService<DB_TYPE , ID_TYPE>) context.getBean(transformerDescription.additionalClass()))
                .findById((ID_TYPE) object)
                .orElseThrow(()-> new TransformException(String.valueOf(object)));
    }

    public abstract boolean isFormObjectTOId();
}
