package systems.dennis.shared.utils.bean_copier;

import lombok.extern.slf4j.Slf4j;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class BeanCopierListTransformer<ID_TYPE extends Serializable> implements AbstractTransformer<ID_TYPE> {
    private Class<?> determineTargetClass(Class<?> cl, DataTransformer dataTransformer) {
        if (AbstractEntity.class.isAssignableFrom(cl)) {
            return dataTransformer.additionalClass().getAnnotation(DataRetrieverDescription.class).form();
        }
        return dataTransformer.additionalClass().getAnnotation(DataRetrieverDescription.class).model();
    }

    @Override
    public <DB_TYPE extends IDPresenter<ID_TYPE>> Object transform(Object object, DataTransformer dataTransformer, Class<?> toType, WebContext.LocalWebContext context) {

        try {
            var beanCopier = context.getBean(BeanCopier.class);
            List<?> items = (List<?>) object;
            List result = new ArrayList<>();

            items.forEach(x -> result.add(beanCopier.copy(x, determineTargetClass(x.getClass(), dataTransformer))));

            return result;
        } catch (Exception e){
            log.debug("error: copying  " + object, e);
        }
        return  null;
    }
}
