package systems.dennis.shared.service;

import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.ApplicationContext;

import java.io.Serializable;

public abstract class ParentalService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> extends ApplicationContext implements AbstractService<DB_TYPE, ID_TYPE>{

    private String getParentField( ){
        return  "parent";
    }

    public ParentalService(WebContext holder) {
        super(holder);
    }

    public long countByParent(ID_TYPE id){
        Specification<DB_TYPE> specification = QueryCase.equalsOf(getParentField(), id).specification();
        return count(specification.and(getAdditionalSpecification()));
    }

    public long countByRoot(AbstractEntity x){
        Specification<DB_TYPE> specification = QueryCase.equalsOf(getParentField(), x).specification();
        return count(specification.and(getAdditionalSpecification()));
    }



    public Page<DB_TYPE> findRootElements(int page, int limit){
        Specification<DB_TYPE> specification = QueryCase.ofNull(getParentField()).specification();
        return find(specification.and(getAdditionalSpecification()), null, limit, page);
    }

    public Page<DB_TYPE> findByParent(Long parentId, int limit, int page){
        Specification<DB_TYPE> specification = QueryCase.equalsOf( getParentField(), parentId ).specification();
        return find(specification.and(getAdditionalSpecification()), null, limit, page);
    }
}
