package systems.dennis.shared.repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.stereotype.Repository;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;
import java.util.Optional;


@Repository
@NoRepositoryBean
public interface AbstractRepository<ENTITY extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> extends CrudRepository<ENTITY, ID_TYPE>, JpaSpecificationExecutor<ENTITY> {
    Page<ENTITY> findAll(Pageable pageRequest);

    Page<ENTITY> findAll(Specification<ENTITY> specification, Pageable pageable);

    default Optional<ENTITY> findFirst(Specification<ENTITY> tSpecification){
        var element = findAll(tSpecification, Pageable.ofSize(1));
        if (element.hasContent()){
            return element.stream().findFirst();
        } else {
            return Optional.empty();
        }
    }

    /**
     *
     * @param entity must not be {@literal null}.
     * @return
     * @param <S>
     *
     * @deprecated Use getService() save method instead of repository. Using this method can provoke different errors and unexpected behaviour
     */
    @Deprecated
    <S extends ENTITY> S save(S entity);
}
