package systems.dennis.shared.controller.items;


import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.form.AbstractForm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * List  object interface. Implementing this interface, will automatically create ../list/
 *
 * @param <DB_TYPE> Entity which is managed by this interface and Service
 *
 * @since 3.1.2 version returns page, and uses Additional specification strictly
 */
@RestController
@Secured
public interface AbstractListItemController<DB_TYPE extends AbstractEntity<ID_TYPE>, FORM extends AbstractForm, ID_TYPE extends Serializable> extends Transformable<DB_TYPE, FORM>, Serviceable, MagicList<DB_TYPE, ID_TYPE> {

    @GetMapping("/list")
    @ResponseBody
    @WithRole
    default ResponseEntity<Page<FORM>> get(@RequestParam(value = "from", required = false) ID_TYPE from,
                                           @RequestParam(value = "limit", required = false) Integer limit,
                                           @RequestParam(value = "page", required = false) Integer page) {

        Specification<AbstractEntity<ID_TYPE>> specification = getService().getAdditionalSpecification();

        return  ResponseEntity.ok(toFormPage(getService().find(specification, from, limit, page)));

    }
}
