package systems.dennis.shared.controller.items;

import lombok.SneakyThrows;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.AbstractForm;

@RestController
@Secured
public interface AbstractGetByIdItemController<DB_TYPE extends AbstractEntity, FORM extends AbstractForm> extends Serviceable, Transformable<DB_TYPE, FORM> {
    @SneakyThrows
    @GetMapping("/id/{id}")
    @ResponseBody
    default ResponseEntity<FORM> get(@PathVariable ("id") Long id) {
        DB_TYPE type = (DB_TYPE) getService().findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        if (type == null){
            throw new ItemNotFoundException(id);
        }
        return ResponseEntity.ok(toForm(type));
    }

}
