package systems.dennis.shared.controller.items;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.magic.MagicForm;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.form.AbstractForm;

/**
 * Update object interface. Implementing this interface, will automatically create ../edit/
 *
 * @param <DB_TYPE> Entity which is managed by this interface and Service
 */
@RestController
@Secured
public interface AbstractEditItemController<DB_TYPE extends AbstractEntity, FORM extends AbstractForm> extends Serviceable, Transformable< DB_TYPE, FORM>, MagicForm<FORM>,
        AbstractEditFieldItemController<DB_TYPE, FORM> {


    @PutMapping(value = "/edit", consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @SelfOnlyRole
    @WithRole
    default ResponseEntity<FORM> edit(@RequestBody FORM form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        validate(form, true);
        return ResponseEntity.ok(toForm((DB_TYPE) getService().edit(fromForm(form))));
    }

}
