package systems.dennis.shared.controller.forms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.annotations.AbstractFormModifier;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AbstractAddItemController;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.service.AbstractService;

import java.io.Serializable;
import java.lang.annotation.Annotation;

@SuppressWarnings("ALL")
public interface Serviceable<DB_TYPE extends AbstractEntity<ID_TYPE>, ID_TYPE extends Serializable> {
    Logger log = LoggerFactory.getLogger(AbstractAddItemController.class);

    default <E extends AbstractEntity, T extends AbstractService<AbstractEntity<ID_TYPE>, ID_TYPE>> T getService() {
        return (T) getContext().getBean(getServiceClass());
    }

    default <E extends AbstractEntity> Class<? extends AbstractService<?, ?>> getServiceClass(){
        return getClass().getAnnotation(WebFormsSupport.class).value();
    }

    WebContext.LocalWebContext getContext();




    static DataRetrieverDescription findDeclaredClass(Class c, DataRetrieverDescription model) {

        if (model == null) {
            WebFormsSupport ser = (WebFormsSupport) c.getAnnotation(WebFormsSupport.class);
            if (ser == null) {
                throw new UnsupportedOperationException("No @FormToModel annotation, no @RepoService annotation on " + c);
            }
            var serviceModel = ser.value();

            model = serviceModel.getAnnotation(DataRetrieverDescription.class);


            if (model == null) {
                throw new UnsupportedOperationException("@FormToModel annotation is not present on " + c + " and not present at service : " + ser.value());
            }

            if (ser.form() != AbstractForm.class) {
                DataRetrieverDescription finalModel = model;
                DataRetrieverDescription description = new DataRetrieverDescription() {
                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return finalModel.annotationType();
                    }

                    @Override
                    public Class<? extends AbstractEntity<?>> model() {
                        return finalModel.model();
                    }

                    @Override
                    public Class<? extends AbstractForm> form() {
                        return ser.form();
                    }

                    @Override
                    public Class<? extends AbstractRepository<?, ?>> repo() {
                        return finalModel.repo();
                    }

                    @Override
                    public Class<? extends AbstractFormModifier> formModifier() {
                        return AbstractFormModifier.class;
                    }
                };
            }
        }
        return model;
    }

    default <T extends AbstractForm> Class<T> getForm() {
        var res = findDeclaredClass(getClass(), getClass().getAnnotation(DataRetrieverDescription.class));

        return (Class<T>) res.form();
    }

    default <T extends AbstractForm> Class<T> getModel() {
        var res = findDeclaredClass(getClass(), getClass().getAnnotation(DataRetrieverDescription.class));

        return (Class<T>) res.model();
    }

    default Logger getLog() {
        return log;
    }
}
