package systems.dennis.shared.beans;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import systems.dennis.shared.config.WebContext;

@Configuration
@Slf4j
public class OnApplicationStart  {

    @Autowired(required = false)
    @Bean
    public CommandLineRunner init(WebContext context, OnAppStart onAppStart){
        return args -> {
            //since 3.1.2 No more forced elements to start only what is defined by application
            if (onAppStart != null){
                onAppStart.onAppRun(context);
            }
        };
    }


}
