package systems.dennis.shared.annotations;

import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.repository.AbstractRepository;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DataRetrieverDescription {
    Class<? extends AbstractEntity<?>> model();
    Class<? extends AbstractForm> form();
    Class<? extends AbstractRepository<?, ?>> repo();
    Class<? extends AbstractFormModifier> formModifier() default AbstractFormModifier.class;

}
