package systems.dennis.shared.entity;

import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import systems.dennis.shared.annotations.FormTransient;

@MappedSuperclass
@Data
public class BaseEntity implements DefaultForm {
    public static final int DELETE_STRATEGY_DB = 1;
    public static final int DELETE_STRATEGY_PROPERTY = 2;
    public static final String DELETE_PROPERTY = "hidden";
    @Id
    @GeneratedValue(generator = "entity-aware-generator",  strategy = GenerationType.SEQUENCE)
    @GenericGenerator(name = "entity-aware-generator",  parameters =  {
            @Parameter(name = "increment_size", value = "1"),
            @Parameter(name = "initial_value", value = "100")

    }, strategy = "systems.dennis.shared.entity.ByEntityNameSequenceGenerator")
    private Long id;

    @FormTransient
    Boolean hidden;




}
