package systems.dennis.shared.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.form.LanguageForm;
import systems.dennis.shared.model.LanguageModel;
import systems.dennis.shared.service.LanguageService;
import systems.dennis.shared.utils.ApplicationContext;

import java.util.Map;

@RestController
@RequestMapping("/api/v2/flaw/language")
@WebFormsSupport(LanguageService.class)
@CrossOrigin
@Secured
public class LanguageController
        extends ApplicationContext
        implements AddItemController<LanguageModel, LanguageForm>,
        EditItemController<LanguageModel, LanguageForm>,
        ListItemController<LanguageModel, LanguageForm>,
        DeleteItemController {

    static {
        SearchEntityApi.registerSearch("language", new SearcherInfo("name", LanguageService.class));
    }


    public LanguageController(WebContext context) {
        super(context);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public ResponseEntity<LanguageForm> add(LanguageForm model) throws ItemForAddContainsIdException {
        return AddItemController.super.add(model);
    }

    @Override
    public Page<Map<String, Object>> fetchData(MagicRequest request) {
        return ListItemController.super.fetchData(request);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public ResponseEntity<LanguageForm> edit(LanguageForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        DeleteItemController.super.delete(id);
    }
}
