package systems.dennis.shared.beans;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.service.AppSettingsService;

@Configuration
@Slf4j
public class OnApplicationStart  {

    @Autowired(required = false)
    @Bean
    public CommandLineRunner init(WebContext context, OnAppStart onAppStart){
        return args -> {
            try {
                context.getBean(AppSettingsService.class).saveApplicationSettingsIntoDB();
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            if (onAppStart != null){
                onAppStart.onAppRun(context);
            }
        };
    }


}
