package systems.dennis.shared.validation;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.ValidationResult;

public class NumberNotZeroValidator implements ValueValidator {

    @Override
    public ValidationResult validate(Class serviceClass, Object element, String field, Object value, boolean edit, WebContext.LocalWebContext context) {

        if (value == null) {
            return ValidationResult.fail("value.should.not.be.null");
        }

        if (value instanceof Number) {
            Number numberValue = (Number) value;
            if (numberValue.longValue() <= 0) {
                return ValidationResult.fail("value.should.be.positive");
            }
        }
        return ValidationResult.PASSED;
    }
}
