package systems.dennis.shared.service;

import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.QueryCase;

public class ParentalService<DB_TYPE extends BaseEntity> extends PaginationService<DB_TYPE>{

    private String getParentField( ){
        return  "parent";
    }

    public ParentalService(WebContext holder) {
        super(holder);
    }

    public long countByParent(Long id){
        Specification<DB_TYPE> specification = QueryCase.equalsOf(getParentField(), id).specification();
        return count(specification.and(getAdditionalSpecification()));
    }

    public long countByRoot(BaseEntity x){
        Specification<DB_TYPE> specification = QueryCase.equalsOf(getParentField(), x).specification();
        return count(specification.and(getAdditionalSpecification()));
    }



    public Page<DB_TYPE> findRootElements(int page, int limit){
        Specification<DB_TYPE> specification = QueryCase.ofNull(getParentField()).specification();
        return find(specification.and(getAdditionalSpecification()), 0L, limit, page);
    }

    public Page<DB_TYPE> findByParent(Long parentId, int limit, int page){
        Specification<DB_TYPE> specification = QueryCase.equalsOf( getParentField(), parentId ).specification();
        return find(specification.and(getAdditionalSpecification()), 0L, limit, page);
    }
}
