package systems.dennis.shared.annotations.security;

import org.springframework.stereotype.Service;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

@Service
public interface ISecurityUtils {
    String USER_ID_FIELD = "userDataId";
    Long getUserDataId();

    void assignUser(DefaultForm pojo);

    void assignUser(DefaultForm form, DefaultForm pojoOriginal);

    default void isMy(Object o){ };

    TokenData getToken();

    boolean isAdmin();

    boolean hasRole(String role);

    String getUserLanguage();

     static QueryCase belongsToMeQuery(Long userId){
        return QueryCase.equalsOf(USER_ID_FIELD, userId);
    }

    default QueryCase belongsToMeQuery(){
        return  belongsToMeQuery(getUserDataId());
    }
    default  <T> DefaultSearchSpecification<T> belongsToMeSpecification(){
        return  belongsToMeQuery(getUserDataId()).specification();
    }
}
