package systems.dennis.shared.annotations;

import systems.dennis.shared.entity.BaseEntity;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DeleteStrategy {
    int value() default BaseEntity.DELETE_STRATEGY_DB;
    String field() default BaseEntity.DELETE_PROPERTY;

    boolean selfOnly() default false;

    boolean storeDeleteEventHistory() default  false;
}
