package systems.dennis.shared.validation;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.form.ServerConfigForm;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.service.ServerConfigService;

public class ServerTypeValidator implements ValueValidator<ServerConfigForm, Long> {
    @Override
    public ValidationResult validate(Class serviceClass, ServerConfigForm element, String field, Long value, boolean edit,  WebContext.LocalWebContext context) {

        try {
            context.getBean(ServerConfigService.class).checkActiveTypeExists(element);
        } catch (Exception e){
            return ValidationResult.fail("server.type.already_active");
        }

        return ValidationResult.PASSED;
    }
}
