package systems.dennis.shared.validation;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.form.FavoriteItemForm;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.service.FavoriteItemService;

public class FavoriteStoreLimitValidator implements ValueValidator {

    public static final String FAVORITE_STORE_LIMIT_VALIDATOR_ERROR_MESSAGE = "global.settings.favorite.store.limit.exceeded";

    @Override
    public ValidationResult validate(Class serviceClass, Object element, String field, Object value, boolean edit, WebContext.LocalWebContext context) {
        FavoriteItemService service = (FavoriteItemService)context.getBean(serviceClass);
        return service.isFavoriteLimitNotExceeded((FavoriteItemForm) element)
                ? ValidationResult.PASSED
                : ValidationResult.fail(FAVORITE_STORE_LIMIT_VALIDATOR_ERROR_MESSAGE);
    }
}
