package systems.dennis.shared.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.form.UserFormSettingsForm;
import systems.dennis.shared.model.UserFormSettingsModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.FieldFormPositionRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.repository.UserFormSettingsRepo;

@Service
@Slf4j
@DataRetrieverDescription(model = UserFormSettingsModel.class, form = UserFormSettingsForm.class, repo = UserFormSettingsRepo.class)
public class UserFormSettingsService extends PaginationService<UserFormSettingsModel> {
    public UserFormSettingsService(WebContext holder) {
        super(holder);
    }

    @Override
    public UserFormSettingsModel preAdd(UserFormSettingsModel object) throws ItemForAddContainsIdException {

        var existing = getRepository().findFirst(createUserFormSpecification(object.getEntityType()));
        var positionBean =   getBean(FieldFormPositionRepository.class);
        existing.ifPresent(userFormSettingsModel ->
        {
            object.setId(userFormSettingsModel.getId());
            try {
                positionBean.deleteAll(existing.get().getPositions());
            } catch (Exception e){
                log.info("Cannot delete old items", e);
            }
        });

        positionBean.saveAll(object.getPositions());


        return super.preAdd(object);
    }

    public DefaultSearchSpecification<UserFormSettingsModel> createUserFormSpecification(String entityType) {
        DefaultSearchSpecification<UserFormSettingsModel> specification = getSelfCreatedItems(getBean(ISecurityUtils.class).getUserDataId(), false);
        var additionalSpecification = QueryCase.equalsOf("entityType", entityType);
        return specification.addCase(additionalSpecification);
    }

}
