package systems.dennis.shared.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.form.ServerConfigForm;
import systems.dennis.shared.model.ServerConfig;
import systems.dennis.shared.repository.ServerConfigRepo;

@Service
@DataRetrieverDescription(repo = ServerConfigRepo.class, form = ServerConfigForm.class, model = ServerConfig.class)
public class ServerConfigService extends PaginationService<ServerConfig>  {
    public ServerConfigService(WebContext holder) {
        super(holder);
    }

    public void checkActiveTypeExists(ServerConfigForm element) {

        if (element.getActive() == null || !element.getActive()) {
            return;
        }

        ServerConfigRepo repo = getRepository();

        if (element.getId() == null) {
            if (repo.existsByTypeAndActiveIsTrue(element.getType())) {
                throw new IllegalArgumentException("Already exists");
            }
        } else {
            if (repo.existsByTypeAndActiveIsTrueAndIdNot(element.getType(), element.getId())) {
                throw new IllegalArgumentException("Already exists");
            }
        }

    }
}
