package systems.dennis.shared.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.form.ScopeRuleForm;
import systems.dennis.shared.model.ScopeRuleModel;
import systems.dennis.shared.repository.ScopeRuleRepo;

@Service
@DataRetrieverDescription(model = ScopeRuleModel.class, form = ScopeRuleForm.class, repo = ScopeRuleRepo.class)
@DeleteStrategy(value = BaseEntity.DELETE_STRATEGY_PROPERTY)
public class ScopeRuleService extends PaginationService<ScopeRuleModel> {

    public ScopeRuleService(WebContext holder) {
        super(holder);
    }
}
