package systems.dennis.shared.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.PersonalSettingsForm;
import systems.dennis.shared.model.PersonalSettingsModel;
import systems.dennis.shared.repository.PersonalSettingsRepo;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model = PersonalSettingsModel.class, form = PersonalSettingsForm.class, repo = PersonalSettingsRepo.class)
@DeleteStrategy(value = BaseEntity.DELETE_STRATEGY_PROPERTY, selfOnly = true)
public class PersonalSettingsService extends PaginationService<PersonalSettingsModel> {
    public PersonalSettingsService(WebContext context){
        super(context);

    }

    public PersonalSettingsModel findFirstByName(String name) {
        Specification<PersonalSettingsModel> settings = getBean(ISecurityUtils.class).belongsToMeSpecification().addCase(getNotDeletedQuery());
        var res  = settings.and(QueryCase.equalsOf( PersonalSettingsModel.PERSONAL_SETTING_NAME_FIELD,  name).specification());

        return getRepository().findOne(res).orElseThrow(() -> new ItemNotFoundException(name));
    }

    @Override
    public PersonalSettingsModel preAdd(PersonalSettingsModel object) throws ItemForAddContainsIdException {



        try {
            var res = findFirstByName(object.getName());
            object.setId(res.getId());
        } catch (Exception exception){
            //ignored all ok
        }
        return super.preAdd(object);
    }

    @Override
    public Specification<PersonalSettingsModel> getAdditionalSpecification() {
        return getBean(ISecurityUtils.class).belongsToMeSpecification().addCase(getNotDeletedQuery());
    }
}
