package systems.dennis.shared.provider;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.DataProvider;
import systems.dennis.shared.pojo_form.ItemValue;
import systems.dennis.shared.pojo_view.DefaultDataConverter;

import java.util.ArrayList;
import java.util.Objects;

public class ServerTypeProvider implements DataProvider<Long>, DefaultDataConverter<Long, String> {

    public static final Long LDAP  = 1L;
    public static final Long FILE_STORAGE  = 0L;
    public static final Long TIME_ZONE  = 2L;

    @Override
    public ArrayList<ItemValue<Long>> getItems( WebContext.LocalWebContext context) {

        var data = new ArrayList<ItemValue<Long>>();
        data.add(new ItemValue<>("FILE_STORAGE", FILE_STORAGE));
        data.add(new ItemValue<>("LDAP", LDAP));
        data.add(new ItemValue<>("TIME_ZONE", TIME_ZONE));


        return data;
    }

    @Override
    public String convert(Long object, String data, WebContext.LocalWebContext context) {
        var items = getItems(  context);

        for (ItemValue value : items){
            if (Objects.equals(value.getValue(), object)){
                return String.valueOf(value.getLabel());
            }
        }
        return String.valueOf(object);
    }
}
