package systems.dennis.shared.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.provider.ServerTypeProvider;
import systems.dennis.shared.validation.ServerTypeValidator;
import systems.dennis.shared.validation.ValueIsIntAndMoreThenZero;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.CHECKBOX;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.DROP_DOWN;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.PASSWORD;

@Data
@PojoListView (actions = {"download",  "new", "settings"})
public class ServerConfigForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement(required = true)
    @PojoListViewField (searchable = true)
    private String name;

    @PojoFormElement(required = true)
    @PojoListViewField (searchable = true)
    private String host;

    @PojoListViewField (searchable = true)
    @PojoFormElement (type =  "number")
    @Validation (ValueIsIntAndMoreThenZero.class)
    private Integer port;

    @PojoListViewField (searchable = true)

    private String userName;

    @PojoFormElement(type = PASSWORD)
    @PojoListViewField(available = false)
    private String password;

    @PojoListViewField (searchable = true)
    private String serverParam;

    @PojoFormElement(type = DROP_DOWN, dataProvider = ServerTypeProvider.class, validators = {ServerTypeValidator.class})
    private Long type;

    @PojoFormElement(type = CHECKBOX, checked = @Checkable(checked = true), remote = @Remote(searchType = "CHECKBOX"))
    private Boolean active;

    @PojoListViewField(showContent = false, actions = {
            @UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)
    })

    @PojoFormElement(type = HIDDEN)
    private Long actions;

}
