package systems.dennis.shared.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.model.UserFormSettingsModel;
import systems.dennis.shared.service.UserFormSettingsService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/shared/form_setting")
@WebFormsSupport(value = UserFormSettingsService.class)
@CrossOrigin
public class UserFormSettingsController
        extends ApplicationContext
        implements AddItemController<UserFormSettingsModel, UserFormSettingsModel>,
        DeleteItemController, EditItemController<UserFormSettingsModel, UserFormSettingsModel> {

    public UserFormSettingsController(WebContext context) {
        super(context);
    }
}
