package systems.dennis.shared.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.ServerConfigForm;
import systems.dennis.shared.model.ServerConfig;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.repository.ServerConfigRepo;
import systems.dennis.shared.service.ServerConfigService;
import systems.dennis.shared.utils.ApplicationContext;

/**
 * Provides Role adding, editing, deleting and assigning
 */
@RestController
@RequestMapping("/api/v2/shared/servers")
@Secured (roles = "ROLE_ADMIN")
@CrossOrigin
@WebFormsSupport(ServerConfigService.class)
public class ServerController extends ApplicationContext implements Serviceable,
        DeleteItemController,
        AddItemController<ServerConfig, ServerConfigForm>,
        EditItemController<ServerConfig, ServerConfigForm>,
        ListItemController<ServerConfig, ServerConfigForm> {

    static  {
        SearchEntityApi.registerSearch("server", new SearcherInfo("name", ServerConfigService.class));
    }

    public ServerController(WebContext context) {
        super(context );
    }

    @WithRole("ROLE_SYNC")
    @GetMapping("/type/{type}")
    public ServerConfigForm findByType(@PathVariable("type") Long type) {
        DefaultSearchSpecification<ServerConfig> specification = QueryCase.equalsOf("type", type)
                .specification().addCase(QueryCase.equalsOf("active", true));

        ServerConfig config = getBean(ServerConfigRepo.class).findFirst(specification)
                .orElseThrow(() -> new ItemNotFoundException(type));

        return toForm(config);
    }
}
