package systems.dennis.shared.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.form.ScopeForm;
import systems.dennis.shared.model.ScopeModel;
import systems.dennis.shared.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/shared/scope")
@WebFormsSupport(value = ScopeService.class)
@CrossOrigin
public class ScopeController extends ApplicationContext
        implements AddItemController<ScopeModel, ScopeForm>,
        EditItemController<ScopeModel, ScopeForm>,
        ListItemController<ScopeModel, ScopeForm>,
        DeleteItemController {

    static  {
        SearchEntityApi.registerSearch("scope", new SearcherInfo("name", ScopeService.class));
    }

    public ScopeController(WebContext context) {
        super(context);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public ResponseEntity<ScopeForm> edit(ScopeForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        DeleteItemController.super.delete(id);
    }

    @Override
    public ScopeService getService() {
        return AddItemController.super.getService();
    }
}
